package gov.va.vinci.dart.json.builder;

import java.util.List;

import gov.va.vinci.dart.biz.RequestParticipantDocumentSummary;
import gov.va.vinci.dart.json.DocumentView;
import gov.va.vinci.dart.json.RequestParticipantDocumentListView;
import gov.va.vinci.dart.json.RequestParticipantDocumentView;

public class RequestParticipantDocumentListViewBuilder {

	public RequestParticipantDocumentListView build(final List<RequestParticipantDocumentSummary> summaryList) {
		RequestParticipantDocumentListView result = new RequestParticipantDocumentListView();
		
		RequestParticipantDocumentView view = null;
		int lastParticipantId = -1;
		int lastDocumentId = -1;
		int lastHeadId = -1;
		int lastReviewNoteId = -1;
		int lastDataSourceId = -1;
		DocumentView docView = null;
		
		for (RequestParticipantDocumentSummary summary : summaryList) {
		
			// look for a change to the site and create a new site view if necessary
			if (view == null || summary.getParticipantId() != lastParticipantId) {
				view = new RequestParticipantDocumentView();
				view.setId(String.valueOf(summary.getParticipantId()));
				view.setParticipantName(summary.getParticipantName());
				view.setUploaded(true);
				
				result.getParticipants().add(view);
				lastParticipantId = summary.getParticipantId();
				lastHeadId = -1;  // new site so cause a new head
				lastDocumentId = -1;
				lastReviewNoteId = -1;
				lastDataSourceId = -1;
			}
			
			if (lastHeadId != summary.getHeadId()) {
				
				if (summary.getUpdatedOn() == null) {
					// this one document not yet uploaded so mark the entire view as not fully uploaded
					view.setUploaded(false);
				}
	
				// did the last document processed have only one version?
				if (docView != null && (docView.getDocVersions() == null || docView.getDocVersions().size()< 1)) {
					docView.setOnlyOneVersion(true);
				}
				
				// fix the requirement string of the last doc view
				if (docView != null) {
					if (docView.getRequirement()==null || docView.getRequirement().length() < 1) {
						docView.setRequirement("Required for Legacy DART");
					}
					else {
						String req = docView.getRequirement();
						docView.setRequirement("Required for " + req);
					}
				}
				
				docView = new DocumentViewBuilder().build(summary);
			
				lastHeadId = summary.getHeadId();
				lastDataSourceId = -1;
				lastReviewNoteId = -1;
				
				view.getDocuments().add(docView);
			}
			else if (lastDocumentId != summary.getDocumentId()) {
				// adding another version
				if( docView != null ) {
					docView.getDocVersions().add(new DocumentVersionViewBuilder().build(summary));
				}
			}
			
			if (summary.getReviewNoteId() != 0 && summary.getReviewNoteId() != lastReviewNoteId) {
				// adding a review note
				if( docView != null ) {
					docView.getReviewNotes().add(new DocumentReviewNoteViewBuilder().build(summary));
				}
				
				lastReviewNoteId = summary.getReviewNoteId();
			}

			// adding required data sources
			if (lastDataSourceId != summary.getDataSourceId()) {

				if( docView != null ) {

					String req = docView.getRequirement();
					if (req == null) {
						req = "";
					}
					if (req.length() > 0) {
						req = req + ",";
					}
					req = req + summary.getDataSourceName();
				
					docView.setRequirement(req);
				}

				lastDataSourceId = summary.getDataSourceId();
			}
			
			lastDocumentId = summary.getDocumentId();
		}
		
		return result;
	}
}
